/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.launchpad;

import java.io.File;
import java.io.IOException;
import oracle.install.commons.base.launchpad.LaunchPadFrame;
import oracle.install.commons.base.launchpad.SetupApp;
import oracle.install.commons.system.process.DefaultRawProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.UIType;

public class LaunchPad
extends Application {
    private SetupApp[] setupApps;
    private File mediaDir = new File(".");

    public SetupApp[] getSetupApps() {
        return this.setupApps;
    }

    public void setSetupApps(SetupApp[] setupApps) {
        this.setupApps = setupApps;
    }

    public File getMediaDir() {
        return this.mediaDir;
    }

    public void setMediaDir(File mediaDir) {
        this.mediaDir = mediaDir;
    }

    protected ProcessLaunchInfo getProcessLaunchInfo(SetupApp setupApp) throws IOException {
        String executable = setupApp.getExecutable();
        File file = new File(this.mediaDir, executable);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(this.mediaDir);
        builder.command().add(file.getCanonicalPath());
        ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(builder, new DefaultRawProcessor(), new DefaultRawProcessor());
        return processLaunchInfo;
    }

    public void launch(SetupApp setupApp) throws Exception {
        ProcessLauncher.launch(this.getProcessLaunchInfo(setupApp));
    }

    @Override
    protected void run() {
        super.run();
        if (this.setupApps != null && this.getUIType() == UIType.GRAPHICAL) {
            LaunchPadFrame frame = new LaunchPadFrame(this.setupApps);
            frame.setVisible(true);
        }
    }
}

